// Teste com PRWIN e emisso de boleto bancrio
// Por Wagner Nunes da Silva
#xtranslate  cx(<l>,<c>,<l2>,<c2>) => dispbox(<l>,<c>,<l2>,<c2>,"Ŀ ")
#xtranslate  bx(<l>,<c>,<l2>,<c2>) => dispbox(<l>,<c>,<l2>,<c2>,"Ŀ")

// DADOS DO CEDENTE
public tnome_cedente:=space(35),tcodigo_cedente:=space(10),trua_cedente:=space(35),;
       tnumero_cedente:=space(10),tbairro_cedente:=space(35),tcidade_cedente:=space(35),;
       tcmp_cedente:=space(20),tuf_cedente:="  ",tcep_cedente:=space(8),;
       temail_cedente:=space(35),tt_i_cedente:="1",tdoc_cedente:=space(18),;
       tdig_cedente:=space(3)

// DADOS DO SACADO
public tnome_sacado:=space(35),trua_sacado:=space(35),;
       tnumero_sacado:=space(10),tbairro_sacado:=space(35),tcidade_sacado:=space(35),;
       tcmp_sacado:=space(20),tuf_sacado:="  ",tcep_sacado:=space(8),;
       temail_sacado:=space(35),tt_i_sacado:="1",tdoc_sacado:=space(18),;
       tbanco_sacado:="   ",tagencia_sacado:=space(10),tdig_sacado:="   ",;
       tconta_sacado:=space(10),tdig_cnt_sacado:="   "

// DATAS E VALORES DO BOLETO
public tdoc_data:=ctod(""),tvenc_data:=ctod(""),tbaixa_data:=ctod(""),;
       tmora_data:=ctod(""),tproc_data:=ctod(""),tcred_data:=ctod(""),;
       tdesc_data:=ctod(""),tabat_data:=ctod(""),tprot_data:=ctod(""),;
       tocor_data:=ctod(""),;
       tvl_doc:=0,tvl_abat:=0,tvl_desc:=0,tvl_juro:=0,tvl_desp:=0,;
       tvl_iof:=0,tvl_odesp:=0,tvl_ocred:=0

// DADOS COMPLEMENTARES
public tcarteira:="   ",tbanco:="   ",tagencia:=space(10),tdigito:="   ",;
       tconta:=space(10),tdigconta:="   ",tmotrej:=space(35),;
       toriginal:=space(35),temissao:="4",tespecie:="28",tinstrucoes:=space(50),;
       tlocalpagamento:=space(45),tnossonumero:=space(10),;
       tseunumero:=space(10),tnumdoc:=space(10),tocororiginal:=space(35),;
       ttipo:="04",taceite:="N",tdesc_rej:=space(35)

set date french
set century on
set confirm on
set wrap on

set color to gr+/bg,w/n
clear
bx(0,0,24,79)
center(0,"[ Teste de emisso de boletos bancrios com o PRWIN 3.5 ]")
cx(5,5,12,26)
save screen to temp
do while .t.
   restore screen from temp
   @ 6,6 prompt "1 - Dados do cedente"
   @ 7,6 prompt "2 - Dados do sacado "
   @ 8,6 prompt "3 - Datas e valores "
   @ 9,6 prompt "4 - Complementares  "
   @ 10,6 prompt "5 - Imprimir        "
   @ 11,6 prompt "6 - Sair <ESC>      "
   menu to op
   do case
      case op=1
         cedente()
      case op=2
         sacado()
      case op=3
         dat_val()
      case op=4
         complementar()
      case op=5
         if !empty(tcarteira) .and. !empty(tbanco)
            imprime()
         else
            alert("Complementar/Carteira/Banco so obrigatrios")
         end if
      case op=6 .or. lastkey()=27
         exit
   endcase
enddo
set color to w/n
clear
? "Obrigado por usar o PRWIN 3.5"
?
? "Wagner Nunes da Silva"
? "HTTP://www.vagucs.com.br"
? "vagucs@vagucs.com.br - vagucs@bol.com.br - vagucs@systemnet.com.br"
?
? "Rua Dom Bosco, 23"
? "Ipanema - MG"
? "CEP: 36.950-000"
? "Telefone: (33) 3314-2242 / (33) 3314-1578 / (33) 9965-1578"

procedure cedente
cx(5,5,15,77)
@ 5,6 say "[ Dados do cedente ]"
@ 6,6 say "Nome.....:" get tnome_cedente
@ 6,54 say "Cdigo.:" get tcodigo_cedente
@ 6,74 get tdig_cedente // Digito do cdigo do cedente
@ 7,6 say "Rua......:" get trua_cedente
@ 7,54 say "N:" get tnumero_cedente
@ 8,6 say "Bairro...:" get tbairro_cedente
@ 9,6 say "Cidade...:" get tcidade_cedente
@ 10,6 say "Complem..:" get tcmp_cedente // Complemento
@ 10,38 say "Estado:" get tuf_cedente
@ 11,6 say "CEP......:" get tcep_cedente
@ 12,6 say "E-mail...:" get temail_cedente
@ 13,6 say "Tipo de inscrio:" get tt_i_cedente picture "9" valid mtic()
@ 14,6 say "Doc Cedente......:" get tdoc_cedente
read

function mtic()
local temp,tela
temp={"0-Outros",;
      "1-P. Fsica",;
      "2-P. Jurdica"}
if lastkey()#9
   for i=1 to len(temp)
      if left(temp[i],1)=tt_i_cedente
         @ 13,25 say space(13)   
         @ 13,25 say temp[i]
         return .t.
      end if
   next
end if
save screen to tela
cx(7,24,21,57)
resp=achoice(8,25,20,56,temp)
if resp#0
   keyboard left(temp[resp],1)+chr(13)
end if
restore screen from tela
return .f.

procedure sacado
cx(5,5,19,77)
@ 5,6 say "[ Dados do Sacado ]"
@ 6,6 say "Nome.....:" get tnome_sacado
@ 7,6 say "Rua......:" get trua_sacado
@ 7,54 say "N:" get tnumero_sacado
@ 8,6 say "Bairro...:" get tbairro_sacado
@ 9,6 say "Cidade...:" get tcidade_sacado
@ 10,6 say "Complem..:" get tcmp_sacado // Complemento
@ 10,38 say "Estado:" get tuf_sacado
@ 11,6 say "CEP......:" get tcep_sacado
@ 12,6 say "E-mail...:" get temail_sacado
@ 13,6 say "Tipo de inscrio:" get tt_i_sacado picture "9" valid mtics()
@ 14,6 say "Doc Sacado.......:" get tdoc_sacado
@ 15,6 say "[ Dados da conta bancria do Sacado ]"
@ 16,6 say "Banco....:" get tbanco_sacado picture "999"
@ 17,6 say "Agncia..:" get tagencia_sacado
@ 17,28 get tdig_sacado // Digito verificador da agencia se houver
@ 18,6 say "Conta....:" get tconta_sacado
@ 18,28 get tdig_cnt_sacado // Digito verificador da conta
read

function mtics()
local temp,tela
temp={"0-Outros",;
      "1-P. Fsica",;
      "2-P. Jurdica"}
if lastkey()#9
   for i=1 to len(temp)
      if left(temp[i],1)=tt_i_sacado
         @ 13,25 say space(13)
         @ 13,25 say temp[i]
         return .t.
      end if
   next
end if
save screen to tela
cx(7,24,21,57)
resp=achoice(8,25,20,56,temp)
if resp#0
   keyboard left(temp[resp],1)+chr(13)
end if
restore screen from tela
return .f.

procedure dat_val
cx(5,5,16,77)
@ 6,6 say "Data do documento....:" get tdoc_data
@ 7,6 say "Data do vencimento...:" get tvenc_data
@ 8,6 say "Data da baixa........:" get tbaixa_data
@ 9,6 say "Data de mora/juros...:" get tmora_data
@ 10,6 say "Data do processamento:" get tproc_data
@ 11,6 say "Data do crdito......:" get tcred_data
@ 12,6 say "Data do desconto.....:" get tdesc_data
@ 13,6 say "Data do abatimento...:" get tabat_data
@ 14,6 say "Data do protesto.....:" get tprot_data
@ 15,6 say "Data da ocorrncia...:" get tocor_data
@ 6,41 say "Vl. documento.:" get tvl_doc picture "999,999.99"
@ 7,41 say "Vl. abatimento:" get tvl_abat picture "999,999.99"
@ 8,41 say "Vl. desconto..:" get tvl_desc picture "999,999.99"
@ 9,41 say "Vl. juros/mora:" get tvl_juro picture "999,999.99"
@ 10,41 say "Vl. despesas..:" get tvl_desp picture "999,999.99"
@ 11,41 say "Vl. IOF.......:" get tvl_iof picture "999,999.99"
@ 12,41 say "Vl. outr.Desp.:" get tvl_odesp picture "999,999.99"
@ 13,41 say "Vl. outr.Cred.:" get tvl_ocred picture "999,999.99"
read

procedure complementar
cx(5,5,22,77)
@ 6,6 say "Carteira.........:" get tcarteira picture "999" valid val(tcarteira)>=10
@ 6,29 say "- Campo obrigatrio"
@ 7,6 say "Banco............:" get tbanco picture "999" valid v_banco()
@ 8,6 say "Agncia..........:" get tagencia
@ 8,36 get tdigito
@ 9,6 say "Conta............:" get tconta
@ 9,36 get tdigconta
@ 10,6 say "Motivo Rejeio..:" get tmotrej
@ 11,6 say "Descrio/Rejei.:" get tdesc_rej
@ 12,6 say "Descr. Ocorrncia:" get toriginal
@ 13,6 say "Emisso do boleto:" get temissao picture "9" valid temite()
@ 14,6 say "Espcie..........:" get tespecie picture "99" valid tespval()
@ 15,6 say "Tipo do documento:" get ttipo picture "99" valid vtipo()
@ 16,6 say "Instrues.......:" get tinstrucoes
@ 17,6 say "Local pagamento..:" get tlocalpagamento
@ 18,6 say "Nosso nmero.....:" get tnossonumero
@ 18,40 say "Seu nmero.:" get tseunumero
@ 19,6 say "Nmero/documento.:" get tnumdoc
@ 20,6 say "Campo Aceite.....:" get taceite picture "S" valid taceite$[SN]
@ 21,6 say "Ocorrncia/Origi.:" get tocororiginal
read

function vtipo
local temp,tela
temp={"01-Remessa:Alterar Nome/Endereo do Sacado",;
      "02-Remessa:Alterar Nmero de Controle",;
      "03-Remessa:Alterar Vencimento",;
      "04-Remessa:Baixar",;
      "05-Remessa:Cancelar Abatimento",;
      "06-Remessa:Cancelar Desconto",;
      "07-Remessa:Cancelar Instruo/Protesto",;
      "08-Remessa:Conceder Abatimento",;
      "09-Remessa:Conceder Desconto",;
      "10-Remessa:Debitar em conta",;
      "11-Remessa:Dispensar Juros",;
      "12-Remessa:Outras ocorrncias",;
      "13-Remessa:Protestar",;
      "14-Remessa:Registrar",;
      "15-Retorno:Abatimento Cancelado",;
      "16-Retorno:Abatimento Concedido",;
      "17-Retorno:Acerto/Depositaria",;
      "18-Retorno:Alterao de Dados da Baixa",;
      "19-Retorno:Alterao de dados/Nova entrada",;
      "20-Retorno:Baixado",;
      "21-Retorno:Baixado/Franco Pagamento",;
      "22-Retorno:Baixado Por Devoluo",;
      "23-Retorno:Baixa ou Liquidao Estornada",;
      "24-Retorno:Baixa por Protesto",;
      "25-Retorno:Baixa Solicitada",;
      "26-Retorno:Comando Recusado",;
      "27-Retorno:Custas do Cartrio/Distribuidor",;
      "28-Retorno:Custa/Edital",;
      "29-Retorno:Dados Alterados",;
      "30-Retorno:Dbito/Custas Antecipadas",;
      "31-Retorno:Dbito em Conta",;
      "32-Retorno:Dbito/Tarifas",;
      "33-Retorno:Desconto Cancelado",;
      "34-Retorno:Desconto Concedido",;
      "35-Retorno:Despesas/Protesto",;
      "36-Retorno:Despesas/Susta/Protesto",;
      "37-Retorno:Encaminhado a Cartrio",;
      "38-Retorno:Endereo Sacado Alterado",;
      "39-Retorno:Instruo/Protesto/Rejeitadas/Sustada ou Pendente",;
      "40-Retorno:Juros Dispensados",;
      "41-Retorno:Liquidado",;
      "42-Retorno:Liquidado em Cartrio",;
      "43-Retorno:Liquidado Parcialmente",;
      "44-Retorno:Liquidado por Conta",;
      "45-Retorno:Liquidado Saldo Restante",;
      "46-Retorno:Liquidado sem Registro",;
      "47-Retorno:Manuteno de Ttulo Vencido",;
      "48-Retorno:Nome do Sacado Alterado",;
      "49-Retorno:Outras Ocorrncias",;
      "50-Retorno:Protestado",;
      "51-Retorno:Protesto ou Sustao Estornado",;
      "52-Retorno:Protesto Sustado",;
      "53-Retorno:Recebimento/Instruo/Alterar Dados",;
      "54-Retorno:Recebimento/Instruo/Alterar/Endereo/Sacado",;
      "55-Retorno:Recebimento/Instruo/Alterar/Nome/Sacado",;
      "56-Retorno:Recebimento/Instruo/Alterar/Tipo/Cobranas",;
      "57-Retorno:Recebimento/Instruo/Alterar/Vencimento",;
      "58-Retorno:Recebimento/Instruo/Baixar",;
      "59-Retorno:Recebimento/Instruo/Cancelar/Abatimento",;
      "60-Retorno:Recebimento/Instruo/Cancelar/Desconto",;
      "61-Retorno:Recebimento/Instruo/Conceder/Abatimento",;
      "62-Retorno:Recebimento/Instruo/Conceder/Desconto",;
      "63-Retorno:Recebimento/Instruo/Dispensar/Juros",;
      "64-Retorno:Recebimento/Instruo/Protestar",;
      "65-Retorno:Recebimento/Instruo/Sustar/Protesto",;
      "66-Retorno:Registro Confirmado",;
      "67-Retorno:Registro Recusado",;
      "68-Retorno:Retirado de Cartrio",;
      "69-Retorno:Tipo de Cobrana Alterado",;
      "70-Retorno:Ttulo em Ser",;
      "71-Retorno:Vencimento Alterado"}
if lastkey()#9
   for i=1 to len(temp)
      if left(temp[i],2)=ttipo
         @ 15,25 say space(50)
         @ 15,25 say left(temp[i],50)
         return .t.
      end if
   next
end if
save screen to tela
cx(7,24,21,57)
resp=achoice(8,25,20,56,temp)
if resp#0
   keyboard left(temp[resp],2)+chr(13)
end if
restore screen from tela
return .f.

procedure tespval
local temp,tela
temp:={"01-Aluguel",;
       "02-Apolice de Seguro",;
       "03-Cheque",;
       "04-Contrato",;
       "05-Contribuio Confederativa",;
       "06-Contribuio/Seguros",;
       "07-Dvida Ativa do Estado",;
       "08-Dvida Ativa do Municpio",;
       "09-Dvida Ativa da Unio",;
       "10-Duplic. Mercantil/Indicao",;
       "11-Duplicata Mercantil",;
       "12-Duplicata Rural",;
       "13-Duplicata de Servio",;
       "14-Duplicata de Servio/Indicao",;
       "15-Fatura",;
       "16-Letra de cambio",;
       "17-Mensalidade Escolar",;
       "18-Nota de Crdito Comercial",;
       "19-Nota de Crdito de Exportao",;
       "20-Nota de Crdito Industrial",;
       "21-Nota de Crdito Rural",;
       "22-Nota de Dbito",;
       "23-Nota Promissria",;
       "24-Nota Promissria Rural",;
       "25-Nota de Seguro",;
       "26-Outros",;
       "27-Parcela de Consrcio",;
       "28-Recibo",; // Default
       "29-Triplicata Mercantil",;
       "30-Triplicata de Servio",;
       "31-Warrant"}
if lastkey()#9
   for i=1 to len(temp)
      if left(temp[i],2)=tespecie
         @ 14,25 say space(33)
         @ 14,25 say temp[i]
         return .t.
      end if
   next
end if
save screen to tela
cx(7,24,21,57)
resp=achoice(8,25,20,56,temp)
if resp#0
   keyboard left(temp[resp],2)+chr(13)
end if
restore screen from tela
return .f.

procedure temite
local temp,tela
temp={"1-Banco Emite",;
      "2-Banco no reemite",;
      "3-Banco reemite",;
      "4-Cliente emite"}
if lastkey()#9
   for i=1 to len(temp)
      if left(temp[i],2)=temissao
         @ 13,25 say space(19)
         @ 13,25 say temp[i]
         return .t.
      end if
   next
end if
save screen to tela
cx(7,24,21,57)
resp=achoice(8,25,20,56,temp)
if resp#0
   keyboard left(temp[resp],1)+chr(13)
end if
restore screen from tela
return .f.

procedure v_banco
local bancos,i,tela
bancos:={"001-Banco do Brasil S/A",;
         "021-Banestes",;
         "033-Banespa",;
         "038-Banestado",;
         "104-Caixa Econ. Federal",;
         "151-Nossa Caixa",;
         "237-Bradesco",;
         "244-Banco Cidade",;
         "275-Banco Real S/A",;
         "291-Banco de Crdito Nacional",;
         "320-Bicbanco",;
         "341-Banco Itau S/A",;
         "347-Sudameris",;
         "353-Banco Santander",;
         "389-Banco Mercantil do Brasil",;
         "394-BMC",;
         "399-HSBC",;
         "409-Unibanco",;
         "422-Banco Safra",;
         "479-Bank Boston",;
         "745-Citi Bank"}
if lastkey()#9
   for i=1 to len(bancos)
      if left(bancos[i],3)=tbanco
         @ 7,25 say space(29)
         @ 7,25 say bancos[i]
         return .t.
      end if
   next
end if
save screen to tela
cx(7,24,21,57)
resp=achoice(8,25,20,56,bancos)
if resp#0
   keyboard left(bancos[resp],3)+chr(13)
end if
restore screen from tela
return .f.

procedure center(l,texto)
@ l,(80-len(texto))/2 say texto

procedure imprime
local impressora
handle:=fopen("prwin.prw")
impressora:= {}
Do While .T.
   linha:= fgetline()
   If (!Empty(linha))
      AAdd(impressora,linha)
   Else
      Exit
   EndIf
EndDo
fclose(handle)
if len(impressora)=0
   alert("Nenhuma impressora na lista ou PRWIN no est rodando.")
else
   Do While (.T.)
      cx(5,5,17,41)
      resp:=achoice(6,6,16,40,impressora)
      If (LastKey()==13)
         Set Printer To boleto.prn
         Set Device To Printer
         @ 0,0 say pr_boleto()+"$BLT$ $IMP$="+alltrim(str(resp))+";"
         Set Device To Screen
         Set Printer To 
         tone(300,1)
         exit
      Else
         Exit
      EndIf
   EndDo
end if

Function FGETLINE
Private return_lin,chunk,bigchunk,oldoffset,at_chr13
return_lin:= ""
bigchunk:= ""
oldoffset:= fseek(handle,0,1)
Do While (.T.)
   chunk:= ""
   chunk:= freadstr(handle,100)
   If (Len(chunk) == 0)
      endof_file:= .T.
      Exit
   EndIf
   bigchunk:= bigchunk+chunk
   If (At(Chr(13),bigchunk) > 0)
      at_chr13:= At(Chr(13),bigchunk)
      fseek(handle,oldoffset)
      return_lin:= freadstr(handle,at_chr13-1)
      fseek(handle,1,1)
      Exit
   EndIf
EndDo
fseek(handle,1,1)
Return return_lin

procedure pr_boleto
local l
l:=""
/* Cedente = Quem emite a boleta*/
l+=iif(!empty(tnome_cedente)  ,"$NOME$="+tnome_cedente+";","")
l+=iif(!empty(tdoc_cedente)   ,"$CPFCGC$="+tdoc_cedente+";","")
l+=iif(!empty(tt_i_cedente)   ,"$TIPO_INSCR$="+tt_i_cedente+";","")
l+=iif(!empty(tcep_cedente)   ,"$CEP$="+tcep_cedente+";","")
l+=iif(!empty(temail_cedente) ,"$EMAIL$="+temail_cedente+";","")
l+=iif(!empty(tcmp_cedente)   ,"$COMPLEMENTO$="+tcmp_cedente+";","")
l+=iif(!empty(tuf_cedente)    ,"$ESTADO$="+tuf_cedente+";","")
l+=iif(!empty(tcidade_cedente),"$CIDADE$="+tcidade_cedente+";","")
l+=iif(!empty(tnumero_cedente),"$NUMERO$="+tnumero_cedente+";","")
l+=iif(!empty(trua_cedente)   ,"$RUA$="+trua_cedente+";","")
l+=iif(!empty(tbairro_cedente),"$BAIRRO$="+tbairro_cedente+";","")
l+=iif(!empty(tcodigo_cedente),"$CODIGOCEDENTE$="+tcodigo_cedente+";","")
l+=iif(!empty(tdig_cedente)   ,"$DIG_CODIGO$="+tdig_cedente+";","")
/* Sacado = Cliente que deve pagar a boleta */
l+=iif(!empty(tnome_sacado),"$SAC_NOME$="+tnome_sacado+";","")
l+=iif(!empty(tdoc_sacado),"$SAC_CPGCGC$="+tdoc_sacado+";","")
l+=iif(!empty(tbairro_sacado),"$SAC_BAIRRO$="+tbairro_sacado+";","")
l+=iif(!empty(tcep_sacado),"$SAC_CEP$="+tcep_sacado+";","")
l+=iif(!empty(tcidade_sacado),"$SAC_CIDADE$="+tcidade_sacado+";","")
l+=iif(!empty(tcmp_sacado),"$SAC_COMPLEMENTO$="+tcmp_sacado+";","")
l+=iif(!empty(temail_sacado),"$SAC_EMAIL$="+temail_sacado+";","")
l+=iif(!empty(tuf_sacado),"$SAC_ESTADO$="+tuf_sacado+";","")
l+=iif(!empty(tnumero_sacado),"$SAC_NUMERO$="+tnumero_sacado+";","")
l+=iif(!empty(trua_sacado),"$SAC_RUA$="+trua_sacado+";","")
l+=iif(!empty(tt_i_sacado),"$SAC_TIPO_INSCR$="+tt_i_sacado+";","")
l+=iif(!empty(tbanco_sacado),"$SAC_BANCO$="+tbanco_sacado+";","")
l+=iif(!empty(tagencia_sacado),"$SAC_AGENCIA$="+tagencia_sacado+";","")
l+=iif(!empty(tdig_sacado),"$SAC_DIG_AGENCIA$="+tdig_sacado+";","")
l+=iif(!empty(tconta_sacado),"$SAC_CONTA$="+tconta_sacado+";","")
l+=iif(!empty(tdig_cnt_sacado),"$SAC_DIG_CONTA$="+tdig_cnt_sacado+";","")
/* Datas e valores */
l+=iif(!empty(tabat_data),"$DT_ABATIMENTO$="+dtoc(tabat_data)+";","")
l+=iif(!empty(tbaixa_data),"$DT_BAIXA$="+dtoc(tbaixa_data)+";","")
l+=iif(!empty(tcred_data),"$DT_CREDITO$="+dtoc(tcred_data)+";","")
l+=iif(!empty(tdesc_data),"$DT_DESCONTO$="+dtoc(tdesc_data)+";","")
l+=iif(!empty(tdoc_data),"$DT_DOC$="+dtoc(tdoc_data)+";","")
l+=iif(!empty(tmora_data),"$DT_MORA$="+dtoc(tmora_data)+";","")
l+=iif(!empty(tocor_data),"$DT_OCORRENCIA$="+dtoc(tocor_data)+";","")
l+=iif(!empty(tproc_data),"$DT_PROCESSA$="+dtoc(tproc_data)+";","")
l+=iif(!empty(tprot_data),"$DT_PROTESTO$="+dtoc(tprot_data)+";","")
l+=iif(!empty(tvenc_data),"$DT_VENCIMENTO$="+dtoc(tvenc_data)+";","")
l+=iif(!empty(tvl_doc),"$VL_DOCUMENTO$="+str(tvl_doc)+";","")
l+=iif(!empty(tvl_abat),"$VL_ABATIMENTO$="+str(tvl_abat)+";","")
l+=iif(!empty(tvl_desc),"$VL_DESCONTO$="+str(tvl_desc)+";","")
l+=iif(!empty(tvl_juro),"$VL_MORA$="+str(tvl_juro)+";","")
l+=iif(!empty(tvl_desp),"$VL_DESPESAS$="+str(tvl_desp)+";","")
l+=iif(!empty(tvl_iof),"$VL_IOF$="+str(tvl_iof)+";","")
l+=iif(!empty(tvl_odesp),"$VL_OUTRASDESPESAS$="+str(tvl_odesp)+";","")
l+=iif(!empty(tvl_ocred),"$VL_OUTROSCREDITOS$="+str(tvl_ocred)+";","")
/* Dados complementares do Boleto */
l+=iif(!empty(tdesc_rej),"$DESC_REJEICAO$="+tdesc_rej+";","")
l+=iif(!empty(tcarteira),"$CARTEIRA$="+tcarteira+";","")
l+=iif(!empty(tbanco),"$BANCO$="+tbanco+";","")
l+=iif(!empty(tagencia),"$AGENCIA$="+tagencia+";","")
l+=iif(!empty(tdigito),"$DIG_AGENCIA$="+tdigito+";","")
l+=iif(!empty(tconta),"$CONTA$="+tconta+";","")
l+=iif(!empty(tdigconta),"$DIG_CONTA$="+tdigconta+";","")
l+=iif(!empty(tmotrej),"$MOTIVO_REJEICAO$="+tmotrej+";","")
l+=iif(!empty(toriginal),"$DESC_ORIGINAL$="+toriginal+";","")
l+=iif(!empty(temissao),"$EMISSAO$="+temissao+";","")
l+=iif(!empty(tespecie),"$ESPECIE$="+tespecie+";","")
l+=iif(!empty(tinstrucoes),"$INSTRUCOES$="+tinstrucoes+";","")
l+=iif(!empty(tlocalpagamento),"$LOCAL_PAGAMENTO$="+tlocalpagamento+";","")
l+=iif(!empty(tnossonumero),"$NOSSO_NUMERO$="+tnossonumero+";","")
l+=iif(!empty(tseunumero),"$SEU_NUMERO$="+tseunumero+";","")
l+=iif(!empty(tnumdoc),"$NUMERO_DOC$="+tnumdoc+";","")
l+=iif(!empty(tocororiginal),"$OCOR_ORIGINAL$="+tocororiginal+";","")
l+=iif(!empty(ttipo),"$TIPO_OCORRENCIA$="+ttipo+";","")
l+=iif(!empty(taceite),"$ACEITEDOC$="+iif(taceite="S","1","2")+";","")
return l
